/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.DefaultFont3DStream;
import com.roguewave.chart.core.v2_1.graphics.Font3DChar;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.awt.Graphics;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;

public class Font3D
implements Serializable {
    boolean loadError_;
    int minX_;
    int minY_;
    int maxX_;
    int maxY_;
    int baseline_;
    Font3DChar[] chars_;
    String name_;

    public Font3D(String string) {
        this.name_ = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.loadError_ = this.loadFont(fileInputStream);
            ((InputStream)fileInputStream).close();
            return;
        }
        catch (IOException iOException) {
            this.loadError_ = true;
            System.err.println("Font3D: WARNING: loading font from file " + string + " failed");
            return;
        }
    }

    public Font3D(URL uRL, String string) {
        this.name_ = string;
        try {
            InputStream inputStream = new URL(uRL, string).openStream();
            this.loadError_ = this.loadFont(inputStream);
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.loadError_ = true;
            System.err.println("Font3D: loading font from URL " + uRL + "/" + string + " failed");
            return;
        }
    }

    public Font3D(InputStream inputStream) {
        try {
            this.loadError_ = this.loadFont(inputStream);
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.loadError_ = true;
            System.err.println("Font3D: loading font from input stream failed");
            return;
        }
    }

    public Font3D() {
        this(DefaultFont3DStream.getInputStream());
    }

    boolean loadFont(InputStream inputStream) {
        Font3DChar font3DChar;
        int n = 0;
        Vector<Font3DChar> vector = new Vector<Font3DChar>();
        while ((font3DChar = Font3DChar.loadChar(inputStream)) != null) {
            if (++n == 1) {
                this.minX_ = font3DChar.minX_;
                this.minY_ = font3DChar.minY_;
                this.maxX_ = font3DChar.maxX_;
                this.maxY_ = font3DChar.maxY_;
            } else {
                if (font3DChar.minX_ < this.minX_) {
                    this.minX_ = font3DChar.minX_;
                } else if (font3DChar.maxX_ > this.maxX_) {
                    this.maxX_ = font3DChar.maxX_;
                }
                if (font3DChar.minY_ < this.minY_) {
                    this.minY_ = font3DChar.minY_;
                } else if (font3DChar.maxY_ > this.maxY_) {
                    this.maxY_ = font3DChar.maxY_;
                }
            }
            vector.addElement(font3DChar);
        }
        this.chars_ = new Font3DChar[n];
        int n2 = 0;
        while (n2 < n) {
            this.chars_[n2] = (Font3DChar)vector.elementAt(n2);
            ++n2;
        }
        int n3 = 65;
        if (n3 >= this.chars_.length) {
            System.err.println("Font3D: full font not loaded, only " + this.chars_.length + " chars successfully loaded.");
            this.loadError_ = true;
        } else {
            this.chars_[0].minX_ = this.chars_[n3].minX_;
            this.chars_[0].maxX_ = this.chars_[n3].maxX_;
            this.chars_[0].minY_ = this.chars_[n3].minY_;
            this.chars_[0].maxY_ = this.chars_[n3].maxY_;
        }
        return false;
    }

    int getBaseline() {
        if (this.loadError_) {
            return 0;
        }
        return this.chars_[65].maxY_;
    }

    int getMaxDescent() {
        if (this.loadError_) {
            return 0;
        }
        return this.maxY_ - this.getBaseline();
    }

    int getMaxAscent() {
        if (this.loadError_) {
            return 0;
        }
        return this.getBaseline() - this.minY_;
    }

    int getHeight() {
        if (this.loadError_) {
            return 0;
        }
        return this.maxY_ - this.minY_;
    }

    public void drawString(Graphics graphics, String string, int n, int n2) {
        if (this.loadError_) {
            return;
        }
        int n3 = n2 - this.getBaseline() - 1;
        int n4 = 0;
        while (n4 < string.length()) {
            int n5 = string.charAt(n4) - 32;
            if (n5 >= 0 && n5 < this.chars_.length) {
                Font3DChar font3DChar = this.chars_[n5];
                font3DChar.draw(graphics, n, n3);
                n += font3DChar.maxX_ - font3DChar.minX_;
            }
            ++n4;
        }
    }

    public int stringWidth(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2) - 32;
            if (n3 >= 0 && n3 < this.chars_.length) {
                Font3DChar font3DChar = this.chars_[n3];
                n += font3DChar.maxX_ - font3DChar.minX_ + 1;
            }
            ++n2;
        }
        return n;
    }

    public Vector stringLines(String string, Point3D point3D, Transform3D transform3D) {
        Vector vector = new Vector();
        if (this.loadError_) {
            return vector;
        }
        int n = this.getBaseline();
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = string.charAt(n3) - 32;
            if (n4 >= 0 && n4 < this.chars_.length) {
                Font3DChar font3DChar = this.chars_[n4];
                Vector vector2 = font3DChar.lines(point3D, n2, n, transform3D);
                int n5 = 0;
                while (n5 < vector2.size()) {
                    vector.addElement(vector2.elementAt(n5));
                    ++n5;
                }
                n2 += font3DChar.maxX_ - font3DChar.minX_ + 1;
            }
            ++n3;
        }
        return vector;
    }

    public Vector stringLines(String string, double d, double d2, double d3, double d4, double d5) {
        Vector vector = new Vector();
        if (this.loadError_) {
            return vector;
        }
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n) - 32;
            if (n2 >= 0 && n2 < this.chars_.length) {
                Font3DChar font3DChar = this.chars_[n2];
                Vector vector2 = font3DChar.lines(d, d2, d3, this.getBaseline(), d4, d5);
                int n3 = 0;
                while (n3 < vector2.size()) {
                    vector.addElement(vector2.elementAt(n3));
                    ++n3;
                }
                d += d4 * (double)(font3DChar.maxX_ - font3DChar.minX_ + 1);
            }
            ++n;
        }
        return vector;
    }

    public Vector stringLines(String string, double d, double d2, double d3, double d4) {
        double d5 = d4 / (double)(this.getBaseline() - this.minY_);
        return this.stringLines(string, d, d2, d3, d5, d5);
    }

    public Vector stringLines(String string, double d, double d2, double d3, double d4, boolean bl) {
        double d5 = d4 / (double)(this.getBaseline() - this.minY_);
        double d6 = bl ? -d5 : d5;
        return this.stringLines(string, d, d2, d3, d5, d6);
    }

    public String toString() {
        return String.valueOf(this.name_) + "(baseline=" + this.getBaseline() + ", maxAscent=" + this.getMaxAscent() + ", maxDescent=" + this.getMaxDescent() + ", height()=" + this.getHeight() + ")";
    }
}

